/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.core;

import com.aptana.core.epl.IMemento;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ObjectUtil;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.IServerType;
import com.aptana.webserver.core.WebServerCorePlugin;
import com.aptana.webserver.internal.core.ServerManager;
import com.aptana.webserver.internal.core.ServerType;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWebServer
implements IExecutableExtension,
IServer {
    protected static final String ELEMENT_NAME = "name";
    private IServerType type;
    private String name;
    protected IServer.State fState = IServer.State.STOPPED;

    protected AbstractWebServer() {
    }

    @Override
    public void loadState(IMemento memento) {
        IMemento child = memento.getChild(ELEMENT_NAME);
        if (child != null) {
            this.name = child.getTextData();
        }
    }

    @Override
    public void saveState(IMemento memento) {
        memento.createChild(ELEMENT_NAME).putTextData(this.name);
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    public final void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.type = new ServerType(config.getAttribute("id"), config.getAttribute(ELEMENT_NAME));
    }

    @Override
    public final IServerType getType() {
        return this.type;
    }

    public final String getId() {
        return this.type == null ? null : this.type.getId();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    @Override
    public IServer.State getState() {
        return this.fState;
    }

    protected void updateState(IServer.State state) {
        if (ObjectUtil.areNotEqual((Object)((Object)state), (Object)((Object)this.fState))) {
            this.fState = state;
            this.fireServerChangedEvent();
        }
    }

    protected void fireServerChangedEvent() {
        ServerManager manager = (ServerManager)WebServerCorePlugin.getDefault().getServerManager();
        manager.fireServerChangeEvent(this);
    }

    @Override
    public IStatus restart(String mode, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IStatus status = this.stop(true, (IProgressMonitor)sub.newChild(30));
        if (!status.isOK()) {
            return status;
        }
        return this.start(mode, (IProgressMonitor)sub.newChild(70));
    }

    @Override
    public Set<String> getAvailableModes() {
        return CollectionsUtil.newSet((Object[])new String[]{"run"});
    }

    @Override
    public boolean canRestart() {
        return true;
    }

    @Override
    public boolean canStart() {
        return true;
    }

    @Override
    public boolean canStop() {
        return true;
    }

    @Override
    public IStatus start(String mode, ILaunch launch, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }
}

